package vinyldb

import (
	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	"golang.org/x/net/context"
)

// GetScheduledVods returns all vods with viewable_at time in the past
func (b *Backend) GetScheduledVods(ctx context.Context) ([]*models.Vod, error) {
	queryParts := []interface{}{
		models.FetchAllVODFieldsQuery(),
		"WHERE viewable_at <= NOW() AND viewable_at > current_timestamp - interval '1 day'",
		"AND viewable <> 'public'",
		models.Active(),
	}
	query := db.BuildQuery(queryParts...)

	rows, err := b.conn.Query(ctx, "get_scheduled_vods", query)
	if err != nil {
		return nil, err
	}
	res, err := models.ReadVodRows(rows, err, b.logger)
	if err != nil {
		return nil, err
	}
	err = b.AttachVodThumbnails(ctx, res)
	if err != nil {
		return nil, err
	}
	return res, err
}
