package vinyldb

import (
	"testing"

	sqlmock "github.com/DATA-DOG/go-sqlmock"

	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"

	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
)

func TestGetScheduledVods(t *testing.T) {
	Convey("Fetching scheduled VODs", t, func() {
		mock, reader := Setup()

		Convey("should query the DB for VODs to be published", func() {
			fakeResult := sqlmock.NewRows(models.VodFields)
			query := `SELECT (.+) FROM vods WHERE viewable_at <= NOW\(\) AND viewable_at > current_timestamp - interval '1 day' AND viewable <> 'public' AND deleted IS NOT TRUE`
			mock.ExpectQuery(query).WillReturnRows(fakeResult)

			_, err := reader.GetScheduledVods(context.Background())
			So(err, ShouldBeNil)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
		})
	})
}
