package vinyldb

import (
	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	"golang.org/x/net/context"
)

// GetTrackAppealsByAmrIDs calls vinylDB to find track appeals associated with an audible magic response.
func (b *Backend) GetTrackAppealsByAmrIDs(ctx context.Context, amrIDs []int) ([]*models.TrackAppeal, error) {
	res := []*models.TrackAppeal{}
	queryParts := []interface{}{
		models.FetchTrackAppeals(),
		"WHERE audible_magic_response_id IN",
	}
	queryParts = append(queryParts, db.Params(len(amrIDs)))

	params := make([]interface{}, len(amrIDs))
	for i, amrID := range amrIDs {
		params[i] = amrID
	}

	query := db.BuildQuery(queryParts...)
	rows, err := b.conn.Query(ctx, "get_track_appeals_by_amr_ids", query, params...)
	res, err = models.ReadTrackAppealRows(rows, err, b.logger)
	return res, err
}
