package vinyldb

import (
	"regexp"
	"testing"

	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"

	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
)

func TestGetTrackAppealsByAmrIDs(t *testing.T) {
	Convey("Fetching track appeals related to AMR's", t, func() {
		mock, reader := Setup()

		Convey("Should run the correct query", func() {
			vodIDs := []int{234, 12309}
			query := regexp.QuoteMeta(models.FetchTrackAppeals() + ` WHERE audible_magic_response_id IN ($1, $2)`)
			mock.ExpectQuery(query).WithArgs(vodIDs[0], vodIDs[1])
			_, err := reader.GetTrackAppealsByAmrIDs(context.Background(), vodIDs)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(err, ShouldNotBeNil)
		})

	})
}
