package vinyldb

import (
	"golang.org/x/net/context"

	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
)

// GetTrackAppealsByVodAppealIDs returns the track appeals with vodAppealID
func (b *Backend) GetTrackAppealsByVodAppealIDs(ctx context.Context, vodAppealIDs []int64) ([]*models.TrackAppeal, error) {
	query := db.BuildQuery(
		models.FetchTrackAppeals(),
		"WHERE vod_appeal_id IN",
		db.Params(len(vodAppealIDs)),
		"ORDER BY id ASC",
	)

	params := make([]interface{}, len(vodAppealIDs))
	for i, vodAppealID := range vodAppealIDs {
		params[i] = vodAppealID
	}

	rows, err := b.conn.Query(ctx, "get_track_appeals_by_vod_appeal_ids", query, params...)
	tas, err := models.ReadTrackAppealRows(rows, err, b.logger)
	return tas, err
}
