package vinyldb

import (
	"regexp"
	"testing"
	"time"

	"golang.org/x/net/context"

	"github.com/DATA-DOG/go-sqlmock"
	"github.com/lib/pq"
	. "github.com/smartystreets/goconvey/convey"

	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
)

func TestGetTrackAppealsByVodAppealID(t *testing.T) {
	Convey("GetTrackAppealsByVodAppealID", t, func() {
		now := time.Now().Round(time.Second)
		mock, reader := Setup()
		vodAppealIDs := []int64{int64(1234), int64(2345)}

		fakeResult := sqlmock.NewRows(models.TrackAppealFields)
		fakeResult.AddRow(
			1234, 1, 1, "", now, now, pq.NullTime{Valid: false})
		fakeResult.AddRow(
			2345, 1, 1, "", now, now, pq.NullTime{Valid: false})

		query := models.FetchTrackAppeals() +
			` WHERE vod_appeal_id IN ($1, $2) ORDER BY id ASC`
		mock.ExpectQuery(regexp.QuoteMeta(query)).WithArgs(vodAppealIDs[0], vodAppealIDs[1]).WillReturnRows(fakeResult)

		trackAppeals, err := reader.GetTrackAppealsByVodAppealIDs(context.Background(), vodAppealIDs)

		So(mock.ExpectationsWereMet(), ShouldBeNil)
		So(len(trackAppeals), ShouldEqual, 2)
		So(err, ShouldBeNil)
	})
}
