package vinyldb

import (
	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	"golang.org/x/net/context"
)

// GetTranscodingVodsCountByUser returns all vods with viewable_at time in the past
func (b *Backend) GetTranscodingVodsCountByUser(ctx context.Context, ownerID int64) (int64, error) {
	query := db.BuildQuery(
		"SELECT COUNT(1) FROM ",
		models.VodTableName,
		"WHERE owner_id =",
		db.Param,
		"AND status IN",
		db.Params(len(models.TranscodingStatuses)),
		"AND broadcast_type = 'upload' AND deleted IS NOT TRUE",
	)

	values := []interface{}{ownerID}
	for _, s := range models.TranscodingStatuses {
		values = append(values, s)
	}

	var res int64
	row := b.conn.QueryRow(ctx, "get_transcoding_vods_count_by_user", query, values...)
	err := row.Scan(&res)
	return res, err
}
