package vinyldb

import (
	"database/sql/driver"
	"testing"

	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"

	sqlmock "github.com/DATA-DOG/go-sqlmock"

	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
)

func TestGetTranscodingVodsCountByUser(t *testing.T) {
	Convey("Fetching vod counts by user", t, func() {
		mock, reader := Setup()
		ownerID := int64(123)

		values := []driver.Value{ownerID}
		for _, s := range models.TranscodingStatuses {
			values = append(values, s)
		}

		Convey("should query the db for all types when the broadcast_type is all", func() {
			fakeResult := sqlmock.NewRows([]string{"count"})
			fakeResult.AddRow(1)
			query := "SELECT COUNT(.+) FROM vods WHERE owner_id = (.+) AND status IN (.+) AND broadcast_type = 'upload' AND deleted IS NOT TRUE"
			mock.ExpectQuery(query).WithArgs(values...).WillReturnRows(fakeResult)

			count, err := reader.GetTranscodingVodsCountByUser(context.Background(), ownerID)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(err, ShouldBeNil)
			So(count, ShouldEqual, 1)
		})
	})
}
