package vinyldb

import (
	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	"golang.org/x/net/context"
)

// GetStaleUnmoderatedVods returns the id of vods in moderation review for over an hour
func (b *Backend) GetStaleUnmoderatedVods(ctx context.Context) ([]*models.Vod, error) {
	query := db.BuildQuery(
		models.FetchAllVODFieldsQuery(),
		"WHERE status = 'under_review'",
		"AND (updated_at < (current_timestamp - interval '1 hour'))",
		models.Active(),
	)

	rows, err := b.conn.Query(ctx, "accept_unmoderated_vods", query)
	if err != nil {
		return nil, err
	}

	results, err := models.ReadVodRows(rows, err, b.logger)
	if err != nil {
		return nil, err
	}
	err = b.AttachVodThumbnails(ctx, results)
	if err != nil {
		return nil, err
	}

	return results, nil
}
