package vinyldb

import (
	"errors"
	"regexp"
	"testing"
	"time"

	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	edgemodels "code.justin.tv/vod/vinyl/models"
	sqlmock "github.com/DATA-DOG/go-sqlmock"
	. "github.com/smartystreets/goconvey/convey"

	"golang.org/x/net/context"
)

func TestGetStaleUnmoderatedVods(t *testing.T) {
	Convey("AcceptUnmoderatedVods", t, func() {
		mock, backend := Setup()
		now := time.Now().UTC()
		Convey("successfully exec updates", func() {
			query := `SELECT (.+) FROM vods WHERE (.+)`
			fakeResult := sqlmock.NewRows(models.VodFields)
			fakeResult.AddRow(
				1, nil, 34, "archive", nil, nil,
				now, nil, nil, nil, nil, nil, nil,
				1238, nil, nil, nil, nil, nil,
				0, 111, nil, nil, nil, nil, nil,
				now, edgemodels.StatusRecording, nil, nil, now,
				"hello", 0, nil, "", nil)
			mock.ExpectQuery(query).WillReturnRows(fakeResult)

			fakeVodThumbnails := sqlmock.NewRows([]string{"id", "vod_id", "path", "offset", "type"})
			mock.ExpectQuery(regexp.QuoteMeta(`SELECT id, vod_id, path, "offset", type FROM vod_thumbnails WHERE vod_id IN ( 1 )`)).WillReturnRows(fakeVodThumbnails)

			_, err := backend.GetStaleUnmoderatedVods(context.Background())
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(err, ShouldBeNil)
		})

		Convey("Returns an error when DB errors", func() {
			query := `SELECT (.+) FROM vods WHERE (.+)`
			mock.ExpectQuery(query).WillReturnError(errors.New("some error"))

			_, err := backend.GetStaleUnmoderatedVods(context.Background())
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(err, ShouldNotBeNil)
		})
	})
}
