package vinyldb

import (
	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	edgemodels "code.justin.tv/vod/vinyl/models"
	"golang.org/x/net/context"
)

// GetUserVideoPrivacyProperties calls vinylDB to find the user video privacy props for a user.
func (b *Backend) GetUserVideoPrivacyProperties(ctx context.Context, userID int64) (*edgemodels.UserVideoPrivacyProperties, error) {
	query := db.BuildQuery(models.FetchUserVideoPrivacyProperties(), "WHERE user_id = ", db.Param)
	row := b.conn.QueryRow(ctx, "get_user_video_privacy_properties", query, userID)
	res, err := models.ReadUserVideoPrivacyPropertiesRow(row, userID)
	return &res, err
}
