package vinyldb

import (
	"fmt"

	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	edgemodels "code.justin.tv/vod/vinyl/models"
	"golang.org/x/net/context"
)

// GetUserVideoPrivacyPropertiesBatch calls vinylDB to find the user video privacy props for a list of users.
func (b *Backend) GetUserVideoPrivacyPropertiesBatch(ctx context.Context, userIDs []int64) (map[int64]edgemodels.UserVideoPrivacyProperties, error) {
	ret := make(map[int64]edgemodels.UserVideoPrivacyProperties)
	if len(userIDs) == 0 {
		return ret, nil
	}

	for _, userID := range userIDs {
		if _, ok := ret[userID]; !ok {
			ret[userID] = edgemodels.UserVideoPrivacyProperties{UserID: userID}
		}
	}

	query := db.BuildQuery(models.FetchUserVideoPrivacyProperties(), "WHERE user_id IN", db.Params(len(userIDs)))
	params := make([]interface{}, len(userIDs))
	for i, userID := range userIDs {
		params[i] = userID
	}
	rows, err := b.conn.Query(ctx, "get_user_video_privacy_properties", query, params...)
	if err != nil {
		fmt.Println("Unable to get batch user video privacy properties: ", err)
		return ret, nil
	}

	props, err := models.ReadUserVideoPrivacyPropertiesRows(rows, b.logger)
	if err != nil {
		fmt.Println("Unable to get batch user video privacy properties: ", err)
		return ret, nil
	}

	for _, prop := range props {
		ret[prop.UserID] = prop
	}

	return ret, nil
}
