package vinyldb

import (
	"database/sql"
	"testing"
	"time"

	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	edgemodels "code.justin.tv/vod/vinyl/models"

	"github.com/DATA-DOG/go-sqlmock"
	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
)

func TestGetUserVideoPrivacyProperties(t *testing.T) {
	now := time.Now()
	Convey("Fetching props for a user", t, func() {
		mock, reader := Setup()

		Convey("Fetches a user's props if it exists", func() {
			userID := int64(123)
			query := models.FetchUserVideoPrivacyProperties() + ` WHERE user_id = (.+)`
			fakeResult := sqlmock.NewRows(models.UserVideoPrivacyPropertiesFields).AddRow(123, false, now, now)
			mock.ExpectQuery(query).WithArgs(userID).WillReturnRows(fakeResult)
			res, err := reader.GetUserVideoPrivacyProperties(context.Background(), userID)

			expected := &edgemodels.UserVideoPrivacyProperties{
				UserID:       userID,
				HideArchives: false,
				UpdatedAt:    now,
				CreatedAt:    now,
			}
			So(res, ShouldResemble, expected)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(err, ShouldBeNil)
		})

		Convey("Returns default props if it doesn't exist", func() {
			userID := int64(123)
			query := models.FetchUserVideoPrivacyProperties() + ` WHERE user_id = (.+)`
			mock.ExpectQuery(query).WithArgs(userID).WillReturnError(sql.ErrNoRows)
			res, err := reader.GetUserVideoPrivacyProperties(context.Background(), userID)

			expected := &edgemodels.UserVideoPrivacyProperties{UserID: userID}
			So(res, ShouldResemble, expected)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(err, ShouldBeNil)
		})

	})
}
