package vinyldb

import (
	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	"golang.org/x/net/context"
)

// GetUserVODProperties calls vinylDB to find the user video privacy props for a user.
func (b *Backend) GetUserVODProperties(ctx context.Context, userID int64) (*models.UserVodProperties, error) {
	query := db.BuildQuery(models.FetchUserVODProperties(), "WHERE user_id = ", db.Param)
	row := b.conn.QueryRow(ctx, "get_user_vod_properties", query, userID)
	res, err := models.ReadUserVODPropertiesRow(row, userID)
	return res, err
}
