package vinyldb

import (
	"golang.org/x/net/context"

	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
)

// GetVodAppealsByVodIDs calls vinylDB to fetch the vod appeals associated with
// the vod ids.
func (b *Backend) GetVodAppealsByVodIDs(ctx context.Context, vodIDs []int64) ([]*models.VodAppeal, error) {
	query := db.BuildQuery(
		models.FetchVODAppeals(),
		"WHERE vod_id IN",
		db.Params(len(vodIDs)),
		"ORDER BY id ASC",
	)

	params := make([]interface{}, len(vodIDs))
	for i, vodID := range vodIDs {
		params[i] = vodID
	}

	rows, err := b.conn.Query(ctx, "get_vod_appeals_by_vod_ids", query, params...)
	vas, err := models.ReadVodAppealRows(rows, err, b.logger)
	return vas, err
}
