package vinyldb

import (
	"regexp"
	"testing"
	"time"

	"golang.org/x/net/context"

	"github.com/DATA-DOG/go-sqlmock"
	"github.com/lib/pq"
	. "github.com/smartystreets/goconvey/convey"

	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
)

func TestGetVodAppealsByVodIDs(t *testing.T) {
	Convey("GetVodAppealsByVodIDs", t, func() {
		now := time.Now().Round(time.Second)
		mock, reader := Setup()
		vodIDs := []int64{int64(1234), int64(2345)}

		fakeResult := sqlmock.NewRows(models.VodAppealFields)
		fakeResult.AddRow(
			1, pq.NullTime{Valid: false}, now, now, 1234, false, "", "", "", "", "", "", "")
		fakeResult.AddRow(
			2, pq.NullTime{Valid: false}, now, now, 2345, false, "", "", "", "", "", "", "")

		query := models.FetchVODAppeals() +
			` WHERE vod_id IN ($1, $2) ORDER BY id ASC`
		mock.ExpectQuery(regexp.QuoteMeta(query)).WithArgs(vodIDs[0], vodIDs[1]).WillReturnRows(fakeResult)

		vodAppeals, err := reader.GetVodAppealsByVodIDs(context.Background(), vodIDs)

		So(mock.ExpectationsWereMet(), ShouldBeNil)
		So(len(vodAppeals), ShouldEqual, 2)
		So(err, ShouldBeNil)
	})
}
