package vinyldb

import (
	"fmt"

	"golang.org/x/net/context"

	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	edgeModels "code.justin.tv/vod/vinyl/models"
)

// GetVodAppealsCount creates a query and sends it to the datastore and returns the
// corresponding vod appeals count that matches the query
func (b *Backend) GetVodAppealsCount(ctx context.Context, priority, resolved edgeModels.NullBool, userInfo string, vodID edgeModels.NullInt64) (int64, error) {
	queryParts := []interface{}{"SELECT COUNT(1) FROM", models.VodAppealsTableName}
	queryParts = append(queryParts, "JOIN", fmt.Sprintf("%s ON %s.id=%s.vod_id", models.VodTableName, models.VodTableName, models.VodAppealsTableName))

	fields, values := createGetVodAppealsParamsQuery(priority, resolved, userInfo, vodID, "deleted is not true")
	queryParts = append(queryParts, fields...)

	query := db.BuildQuery(queryParts...)
	var res int64
	row := b.conn.QueryRow(ctx, "get_vod_appeals_count", query, values...)
	err := row.Scan(&res)
	return res, err
}
