package vinyldb

import (
	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/utils"
	"golang.org/x/net/context"
)

// GetVodIDsByUser queries for all ids of vods owned by the given user
func (b *Backend) GetVodIDsByUser(ctx context.Context, userID int64) ([]int64, error) {
	query := db.BuildQuery(
		"SELECT id",
		"FROM vods",
		"WHERE owner_id =", db.Param,
	)
	vodIDRows, err := b.conn.Query(ctx, "get_vod_ids_by_user", query, userID)
	if err != nil {
		return []int64{}, err
	}
	defer utils.CloseRows(vodIDRows, b.logger)

	var vodIDs []int64
	for vodIDRows.Next() {
		var id int64
		if err = vodIDRows.Scan(&id); err != nil {
			return []int64{}, err
		}
		vodIDs = append(vodIDs, id)
	}

	return vodIDs, nil
}
