package vinyldb

import (
	"regexp"
	"testing"

	sqlmock "github.com/DATA-DOG/go-sqlmock"

	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
)

func TestGetVodsIDsByUser(t *testing.T) {
	Convey("Getting a user's vods", t, func() {
		mock, reader := Setup()
		Convey("Should query the db for user's vods", func() {
			userID := int64(123)
			query := regexp.QuoteMeta(
				`SELECT id ` +
					`FROM vods ` +
					`WHERE owner_id = $1`,
			)

			fakeResult := sqlmock.NewRows([]string{"id"})
			fakeResult.AddRow(1)
			mock.ExpectQuery(query).WithArgs(userID).WillReturnRows(fakeResult)

			_, err := reader.GetVodIDsByUser(context.Background(), userID)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(err, ShouldBeNil)
		})
	})
}
