package vinyldb

import (
	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	"golang.org/x/net/context"
)

// GetVodNotificationSettingsByVodIDs calls vinylDB to fetch the notification settings associated
// with the vod ids.
func (b *Backend) GetVodNotificationSettingsByVodIDs(ctx context.Context, vodIDs []int64) ([]*models.VodNotificationSettings, error) {
	query := db.BuildQuery(
		models.FetchVodNotificationSettingsQuery(),
		"WHERE vod_id IN",
		db.Params(len(vodIDs)),
		"ORDER BY id ASC",
	)

	params := make([]interface{}, len(vodIDs))
	for i, vodID := range vodIDs {
		params[i] = vodID
	}

	rows, err := b.conn.Query(ctx, "get_vod_notification_settings_by_vod_ids", query, params...)
	list, err := models.ReadVodNotificationSettingsRows(rows, err, b.logger)
	return list, err
}
