package vinyldb

import (
	"testing"

	sqlmock "github.com/DATA-DOG/go-sqlmock"

	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"

	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
)

func TestGetVodNotificationSettingsByVodIDs(t *testing.T) {
	Convey("Fetching notification settings by VOD ID", t, func() {
		mock, reader := Setup()
		ids := []int64{420, 42}

		Convey("should query the DB for VOD Notification Settings", func() {
			fakeResult := sqlmock.NewRows(models.VodNotificationSettingsFields)
			query := `SELECT (.+) FROM vod_notification_settings WHERE vod_id IN (.+) ORDER BY id ASC`
			mock.ExpectQuery(query).WithArgs(420, 42).WillReturnRows(fakeResult)

			_, err := reader.GetVodNotificationSettingsByVodIDs(context.Background(), ids)
			So(err, ShouldBeNil)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
		})
	})
}
