package vinyldb

import (
	"golang.org/x/net/context"

	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/utils"
	"code.justin.tv/vod/vinyl/models"
)

// GetVodThumbnails gets a vod's thumbnails
func (b *Backend) GetVodThumbnails(ctx context.Context, vodID int64) (models.Thumbnails, error) {
	query := db.BuildQuery("SELECT path, \"offset\" FROM vod_thumbnails WHERE vod_id = ", db.Param)
	rows, err := b.conn.Query(context.Background(), "select_vod_thumbnails", query, vodID)
	if err != nil {
		return models.Thumbnails{}, err
	}
	defer utils.CloseRows(rows, b.logger)

	thumbnails := models.Thumbnails{}
	for rows.Next() {
		thumbnail := &models.Thumbnail{}
		err = rows.Scan(&thumbnail.Path, &thumbnail.Offset)
		if err != nil {
			return models.Thumbnails{}, err
		}
		thumbnails = append(thumbnails, thumbnail)
	}

	return thumbnails, nil
}
