package vinyldb

import (
	"golang.org/x/net/context"

	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	edge "code.justin.tv/vod/vinyl/models"
)

// GetVodsAggregationByID calls vinylDB to fetch the vods that correspond to the list of input IDs.
func (b *Backend) GetVodsAggregationByID(ctx context.Context, vodIds []int64, filters *edge.VodFilters) (*models.VodsAggregation, error) {
	queryParts := []interface{}{
		models.FetchVodsAggregation(),
		"WHERE id IN", db.Params(len(vodIds)),
	}

	queryParts = models.AppendVodFilters(queryParts, filters)

	ids := []interface{}{}
	for _, id := range vodIds {
		ids = append(ids, id)
	}

	query := db.BuildQuery(queryParts...)

	row := b.conn.QueryRow(ctx, "get_vods_aggregation_by_id", query, ids...)
	res, err := models.ReadVodsAggregationRow(row, b.logger)
	return res, err
}
