package vinyldb

import (
	"golang.org/x/net/context"

	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	edge "code.justin.tv/vod/vinyl/models"
)

// GetVodsByID calls vinylDB to fetch the vods that correspond to the list of input IDs.
func (b *Backend) GetVodsByID(ctx context.Context, vodIds []int64, filters *edge.VodFilters) ([]*models.Vod, error) {
	res := []*models.Vod{}
	queryParts := []interface{}{
		models.FetchAllVODFieldsQuery(),
		"WHERE id IN", db.Params(len(vodIds)),
	}

	queryParts = models.AppendVodFilters(queryParts, filters)

	ids := []interface{}{}
	for _, id := range vodIds {
		ids = append(ids, id)
	}

	query := db.BuildQuery(queryParts...)

	rows, err := b.conn.Query(ctx, "get_vods_by_id", query, ids...)
	res, err = models.ReadVodRows(rows, err, b.logger)
	if err != nil {
		return nil, err
	}
	err = b.AttachVodThumbnails(ctx, res)
	if err != nil {
		return nil, err
	}

	return res, err
}
