package vinyldb

import (
	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	edge "code.justin.tv/vod/vinyl/models"
	"golang.org/x/net/context"
)

// GetVodsCountByUser calls vinylDB to find the vod count for a user with the relevant broadcast type.
func (b *Backend) GetVodsCountByUser(ctx context.Context, userID int, broadcastType, language, status []string, filters *edge.VodFilters) (int64, error) {
	queryParts := []interface{}{
		"SELECT COUNT(1) FROM", models.VodTableName,
		"WHERE owner_id =", db.Param,
	}
	values := []interface{}{userID}

	for _, b := range broadcastType {
		values = append(values, b)
	}
	queryParts = append(queryParts, "AND broadcast_type IN ", db.Params(len(broadcastType)))

	if len(language) > 0 {
		for _, l := range language {
			values = append(values, l)
		}
		queryParts = append(queryParts, "AND language IN ", db.Params(len(language)))
	}

	if len(status) > 0 {
		for _, s := range status {
			values = append(values, s)
		}
		queryParts = append(queryParts, "AND status IN ", db.Params(len(status)))
	}

	queryParts = models.AppendVodFilters(queryParts, filters)

	query := db.BuildQuery(queryParts...)

	var res int64
	row := b.conn.QueryRow(ctx, "get_vods_count_for_user", query, values...)
	err := row.Scan(&res)
	if err != nil {
		return 0, err
	}

	return res, nil
}
