package vinyldb

import (
	"database/sql/driver"
	"time"
)

// AnyTime is a object that can be used to match any time object in a result.
type AnyTime struct{}

// Match satisfies sqlmock.Argument interface
func (a AnyTime) Match(v driver.Value) bool {
	t, ok := v.(time.Time)
	if !ok {
		return ok
	}
	location := t.Location()
	return location.String() == "UTC"
}

// AnyEpoch is used to match against unix epoch time.
type AnyEpoch struct{}

// Match satisfies sqlmock.Argument interface
func (a AnyEpoch) Match(v driver.Value) bool {
	_, ok := v.(int64)
	return ok
}

// IntMatcher is used to match an integer amongst a set of possible values.
type IntMatcher struct {
	vals []int64
}

// Match satisfies sqlmock.Argument interface
func (a IntMatcher) Match(v driver.Value) bool {
	val, ok := v.(int64)
	if ok {
		for _, k := range a.vals {
			if k == val {
				return true
			}
		}
	}
	return false
}
