package models

import (
	"strings"

	"code.justin.tv/chat/db"
	"code.justin.tv/common/golibs/errorlogger"

	"code.justin.tv/vod/vinyl/models"
)

var (
	// VodsAggregationFields are the fields queried from the DB for the VOD aggregation
	VodsAggregationFields = []string{"COUNT(id)", "COALESCE(SUM(duration), 0)"}
)

// FetchVodsAggregation returns a string used to fetch the VOD aggregation
func FetchVodsAggregation() string {
	return "SELECT " + strings.Join(VodsAggregationFields, ",") + " FROM " + VodTableName
}

// VodsAggregation represents a  vod aggregation object.
type VodsAggregation struct {
	TotalCount    uint64
	TotalDuration uint64
}

// AsVinylVodsAggregation converts a  vod object into a Vinyl vod object to be returned.
func (V *VodsAggregation) AsVinylVodsAggregation() (*models.VodsAggregation, error) {
	return &models.VodsAggregation{
		TotalCount:    V.TotalCount,
		TotalDuration: V.TotalDuration,
	}, nil
}

// ReadVodsAggregationRow converts the results of a query into a vods aggregation to be returned.
func ReadVodsAggregationRow(row db.Row, logger errorlogger.ErrorLogger) (*VodsAggregation, error) {
	res := &VodsAggregation{}

	if err := row.Scan(
		&res.TotalCount,
		&res.TotalDuration,
	); err != nil {
		return nil, err
	}

	return res, nil
}
