package models

// asVinylVodParams contains the parameters that are used to convert the DB representation of a vod to its corresponding API representation.
type asVinylVodParams struct {
	containShowFormats bool
}

// AsVinylVodOpt is a configuration option for converting the DB representation of a vod to its corresponding API representation.
type AsVinylVodOpt func(*asVinylVodParams)

// SetShowFormats determines whether we will populate the ShowFormats field in the API vod.
func SetShowFormats(shouldCompute bool) AsVinylVodOpt {
	return func(params *asVinylVodParams) {
		params.containShowFormats = shouldCompute
	}
}
