package models

import "code.justin.tv/chat/db"

const deprecatedRechatOwnerTable = "deprecated_vod_owner_used_for_rechat"

// OwnerForRechatFields is the list of fields passed read from the database
var (
	OwnerForRechatFields = []string{
		"vod_id",
		"owner_login",
	}
)

// VodOwner is representation of the fields in the deprecated_vod_owner_used_for_rechat table
type VodOwner struct {
	VodID      int    `json:"vod_id"`
	OwnerLogin string `json:"owner_login"`
}

// FetchAllVODOwnerFieldsQuery returns a string used to query for all columns in the deprecated_vod_owner_used_for_rechat table.
func FetchAllVODOwnerFieldsQuery() string {
	return "SELECT * FROM " + deprecatedRechatOwnerTable
}

// ReadVodOwnerRow reads the results of a query and turns it into a list of props objects to be returned.
func ReadVodOwnerRow(row db.Row) (*VodOwner, error) {
	res := &VodOwner{}

	err := row.Scan(
		&res.VodID,
		&res.OwnerLogin,
	)

	if err == db.ErrNoRows {
		return res, nil
	}
	if err != nil {
		return res, err
	}

	return res, nil
}
