package models

import (
	edge "code.justin.tv/vod/vinyl/models"
)

// VodThumbnail database representation of a vod_thumbnail
type VodThumbnail struct {
	ID     int64
	VodID  int64
	Path   string
	Offset *float32
	Type   string
}

// VodThumbnails collection of VodThumbnails
type VodThumbnails []*VodThumbnail

// ToVinylVodThumbnail convert to user-facing representation of a vod_thumbnail
func (t *VodThumbnail) ToVinylVodThumbnail() *edge.Thumbnail {
	thumbnail := &edge.Thumbnail{
		Path: t.Path,
	}
	if t.Offset != nil {
		dynamicOffset := edge.DynamicFloat32(*t.Offset)
		thumbnail.Offset = &dynamicOffset
	}
	return thumbnail
}
