package vinyldb

import (
	"golang.org/x/net/context"

	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
)

// OwnerForRechat calls vinylDB to fetch the vods that correspond to the list of input IDs.
func (b *Backend) OwnerForRechat(ctx context.Context, vodID int64) (*models.VodOwner, error) {
	query := db.BuildQuery(models.FetchAllVODOwnerFieldsQuery(), "WHERE vod_id = ", db.Param)
	row := b.conn.QueryRow(ctx, "owner_for_rechat", query, vodID)
	res, err := models.ReadVodOwnerRow(row)
	if err != nil {
		return nil, err
	}

	return res, err
}
