package vinyldb

import (
	"database/sql"
	"regexp"
	"testing"

	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"

	"github.com/DATA-DOG/go-sqlmock"
	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
)

func TestOwnerForRechat(t *testing.T) {

	Convey("Fetching owner information for vod id", t, func() {
		mock, reader := Setup()

		Convey("Fetches a owner information if vod exists", func() {
			VodID := int64(123)
			query := models.FetchAllVODOwnerFieldsQuery() + ` WHERE vod_id = $1`
			fakeResult := sqlmock.NewRows(models.OwnerForRechatFields).AddRow(123, "test_login")
			mock.ExpectQuery(regexp.QuoteMeta(query)).WithArgs(VodID).WillReturnRows(fakeResult)
			res, err := reader.OwnerForRechat(context.Background(), VodID)

			expected := &models.VodOwner{
				VodID:      int(VodID),
				OwnerLogin: "test_login",
			}
			So(res, ShouldResemble, expected)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(err, ShouldBeNil)
		})

		Convey("Returns default props if it doesn't exist", func() {
			VodID := int64(123)
			query := models.FetchAllVODOwnerFieldsQuery() + ` WHERE vod_id = $1`
			mock.ExpectQuery(regexp.QuoteMeta(query)).WithArgs(VodID).WillReturnError(sql.ErrNoRows)
			res, err := reader.OwnerForRechat(context.Background(), VodID)

			expected := &models.VodOwner{}
			So(res, ShouldResemble, expected)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(err, ShouldBeNil)
		})

	})
}
