package vinyldb

import (
	"strings"

	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	edgemodels "code.justin.tv/vod/vinyl/models"
	"golang.org/x/net/context"
)

// SetUserVideoPrivacyProperties calls vinylDB to set user video privacy props for a user.
func (b *Backend) SetUserVideoPrivacyProperties(ctx context.Context, userID int64, u *edgemodels.UserVideoPrivacyPropertiesInput) (*edgemodels.UserVideoPrivacyProperties, error) {
	// We first check uniqueness on the prop to see if it already exists.
	// This will be removed once we have completed the migration and we are able to use our own db with
	// upsert functionality.
	query := db.BuildQuery(
		"SELECT id FROM ", models.UserVideoPrivacyPropertiesTableName, "WHERE user_id = ", db.Param)

	var existingID int
	err := b.conn.QueryRow(ctx, "check_user_video_privacy_properties_exists", query, userID).Scan(&existingID)

	if err != nil && err != db.ErrNoRows {
		return nil, err
	}

	var row db.Row
	if err == db.ErrNoRows {
		// Insert new row
		values := models.CreateUserVideoPrivacyPropertiesQuery(userID, *u)

		query = db.BuildQuery(
			"INSERT INTO", models.UserVideoPrivacyPropertiesTableName,
			BuildParamList(models.UserVideoPrivacyPropertiesFields),
			"VALUES", BuildValuesList(1, len(models.UserVideoPrivacyPropertiesFields)),
			"RETURNING", strings.Join(models.UserVideoPrivacyPropertiesFields, ","),
		)

		row = b.conn.QueryRow(ctx, "create_user_video_privacy_properties", query, values...)
	} else {
		// Update existing row
		fields, values := models.UpdateUserVideoPrivacyPropertiesQuery(*u)

		queryParts := []interface{}{"UPDATE", models.UserVideoPrivacyPropertiesTableName, "SET"}
		queryParts = append(queryParts, fields...)
		queryParts = append(queryParts, "WHERE user_id =", db.Param,
			"RETURNING", strings.Join(models.UserVideoPrivacyPropertiesFields, ","))

		values = append(values, userID)

		row = b.conn.QueryRow(ctx, "update_user_video_privacy_properties", db.BuildQuery(queryParts...), values...)
	}

	res, err := models.ReadUserVideoPrivacyPropertiesRow(row, userID)
	return &res, err

}
