package vinyldb

import (
	"strings"

	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	edgemodels "code.justin.tv/vod/vinyl/models"
	"golang.org/x/net/context"
)

// SetUserVODProperties calls vinylDB to set VOD properties for a user.
func (b *Backend) SetUserVODProperties(ctx context.Context, userID int64, u *edgemodels.UserVODPropertiesInput) (*models.UserVodProperties, error) {

	updateFields, updateValues := models.UpdateUserVODPropertiesQuery(*u)

	queryParts := []interface{}{
		"INSERT INTO", models.UserVODPropertiesTableName,
		BuildParamList(models.UserVODPropertiesFields),
		"VALUES (",
	}
	for i := 0; i < len(models.UserVODPropertiesFields); i++ {
		if i != 0 {
			queryParts = append(queryParts, ",")
		}
		queryParts = append(queryParts, db.Param)
	}

	queryParts = append(queryParts, ") ON CONFLICT (user_id) DO UPDATE SET")
	queryParts = append(queryParts, updateFields...)
	queryParts = append(queryParts, "RETURNING ", strings.Join(models.UserVODPropertiesFields, ","))
	insertQuery := db.BuildQuery(queryParts...)

	insertValues := models.CreateUserVODPropertiesQuery(userID, *u)
	values := make([]interface{}, 0, len(updateValues)+len(insertValues))
	values = append(values, insertValues...)
	values = append(values, updateValues...)

	row := b.conn.QueryRow(ctx, "create_user_vod_properties", insertQuery, values...)

	res, err := models.ReadUserVODPropertiesRow(row, userID)
	return res, err
}
