package vinyldb

import (
	"database/sql"
	"testing"
	"time"

	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	edgemodels "code.justin.tv/vod/vinyl/models"
	sqlmock "github.com/DATA-DOG/go-sqlmock"
	. "github.com/smartystreets/goconvey/convey"

	"golang.org/x/net/context"
)

func TestSetUserVODProperties(t *testing.T) {
	now := time.Now().UTC()
	Convey("SetUserVODProperties", t, func() {
		mock, backend := Setup()

		Convey("updates properties on an existing user", func() {
			userID := int64(1238)
			u := edgemodels.UserVODPropertiesInput{
				CanUploadVOD: edgemodels.NullBool{Bool: true, Valid: true},
				UpdatedAt:    now,
				CreatedAt:    now,
			}

			query := `INSERT INTO ` + models.UserVODPropertiesTableName + ` (.+) VALUES (.+) ON CONFLICT (.+) DO UPDATE SET (.+) RETURNING (.+)`
			fakeResult := sqlmock.NewRows(models.UserVODPropertiesFields).AddRow(userID, false, 14, true, false, false, now, now)
			mock.ExpectQuery(query).WithArgs(userID, false, 14, true, false, false, now, now, true, AnyTime{}).WillReturnRows(fakeResult)

			res, err := backend.SetUserVODProperties(context.Background(), userID, &u)
			expected := &models.UserVodProperties{
				UserID:                   userID,
				SaveVODsForever:          sql.NullBool{Valid: true, Bool: false},
				VODStorageDays:           sql.NullInt64{Valid: true, Int64: 14},
				CanUploadVOD:             sql.NullBool{Valid: true, Bool: true},
				YoutubeExportingDisabled: sql.NullBool{Valid: true, Bool: false},
				SkipUploadModeration:     sql.NullBool{Valid: true, Bool: false},
				UpdatedAt:                now,
				CreatedAt:                now,
			}
			So(res, ShouldResemble, expected)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(err, ShouldBeNil)
		})
	})
}
