package vinyldb

import (
	"regexp"
	"testing"
	"time"

	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	edgemodels "code.justin.tv/vod/vinyl/models"

	"golang.org/x/net/context"

	sqlmock "github.com/DATA-DOG/go-sqlmock"
	. "github.com/smartystreets/goconvey/convey"
)

func TestSetViewcounts(t *testing.T) {
	Convey("When calling SetViewcounts", t, func() {
		mock, backend := Setup()
		counts := map[int]int64{
			123: int64(322),
			456: int64(644),
		}
		now := time.Now().Round(time.Second)
		km := IntMatcher{}
		vm := IntMatcher{}
		for k, v := range counts {
			km.vals = append(km.vals, int64(k))
			vm.vals = append(vm.vals, v)
		}

		query := "UPDATE vods SET views_count = c.count FROM (VALUES ($1::integer,$2::integer),($3::integer,$4::integer) ) AS c (c_id, count) WHERE vods.id = c.c_id RETURNING id,bitrates,broadcast_id,broadcast_type,broadcaster_software,codecs,created_at,created_by_id,deleted,delete_at,description,description_html,display_names,duration,formats,fps,game,language,manifest,\"offset\",owner_id,origin,playlist_preferences,published_at,resolutions,source_archive_id,started_on,status,tag_hstore,title,updated_at,uri,views_count,viewable_at"

		Convey("Runs the correct query with valid params", func() {
			rows := sqlmock.NewRows(models.VodFields).AddRow(1, nil, 34, "archive", nil, nil,
				now, nil, nil, nil, nil, nil, nil,
				1238, nil, nil, nil, nil, nil,
				0, 111, nil, nil, nil, nil, nil,
				now, edgemodels.StatusRecording, nil, nil, now,
				"happy", 0, nil, nil, nil)
			mock.ExpectQuery(regexp.QuoteMeta(query)).WithArgs(km, vm, km, vm).WillReturnRows(rows)

			fakeVodThumbnails := sqlmock.NewRows([]string{"id", "vod_id", "path", "offset", "type"})
			mock.ExpectQuery(regexp.QuoteMeta(`SELECT id, vod_id, path, "offset", type FROM vod_thumbnails WHERE vod_id IN ( 1 )`)).WillReturnRows(fakeVodThumbnails)

			_, err := backend.SetViewcounts(context.Background(), counts)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(err, ShouldBeNil)
		})
	})
}
