package vinyldb

import (
	"strings"

	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	"code.justin.tv/vod/vinyl/errors"

	"golang.org/x/net/context"
)

// SetFieldsQuery generates the strings for the fields and values ncessary for an update operation.
func SetFieldsQuery(updateFields map[string]interface{}) ([]interface{}, []interface{}) {
	retFields := []interface{}{}
	retValues := []interface{}{}
	for key, value := range updateFields {
		retFields = append(retFields, key, "=", db.Param, ",")
		retValues = append(retValues, value)
	}

	retFields = retFields[0 : len(retFields)-1] // remove last comma

	return retFields, retValues
}

// UpdateAMR calls vinylDB to update the fields in the corresponding audible magic response entry.
func (b *Backend) UpdateAMR(ctx context.Context, amrID int, updateFields map[string]interface{}) (*models.AMR, error) {
	queryParts := []interface{}{"UPDATE", models.AMRTableName, "SET"}
	fields, values := SetFieldsQuery(updateFields)
	queryParts = append(queryParts, fields...)
	queryParts = append(queryParts, "WHERE id =", db.Param, "RETURNING", strings.Join(models.AMRFields, ","))
	query := db.BuildQuery(queryParts...)
	values = append(values, amrID)
	rows, err := b.conn.Query(ctx, "update_amr", query, values...)

	res, err := models.ReadAMRRows(rows, err, b.logger)
	if err != nil {
		return nil, err
	}

	if len(res) != 1 {
		return nil, errors.NotFoundError{Type: "AMR", ID: amrID}
	}

	return res[0], nil

}
