package vinyldb

import (
	//"database/sql/driver"

	"testing"
	"time"

	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"

	sqlmock "github.com/DATA-DOG/go-sqlmock"
	. "github.com/smartystreets/goconvey/convey"

	"golang.org/x/net/context"
)

func TestUpdateAMRs(t *testing.T) {
	Convey("Updating AMRs", t, func() {
		mock, backend := Setup()

		Convey("returns an error when the original AMR is not found", func() {
			amrID := 123
			updateFields := map[string]interface{}{
				"song": "hello",
			}

			query := `UPDATE audible_magic_responses SET (.+) WHERE (.+) RETURNING (.+)`
			amrResult := sqlmock.NewRows(models.AMRFields)
			mock.ExpectQuery(query).WithArgs("hello", amrID).WillReturnRows(amrResult)

			_, err := backend.UpdateAMR(context.Background(), amrID, updateFields)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(err.Error(), ShouldContainSubstring, "AMR with ID 123 not found")
		})

		Convey("returns the updated AMR when it is found", func() {
			amrID := 123
			updateFields := map[string]interface{}{
				"song": "hello",
			}

			query := `UPDATE audible_magic_responses SET (.+) WHERE (.+) RETURNING (.+)`
			now := time.Now()
			amrResult := sqlmock.NewRows(models.AMRFields)
			amrResult.AddRow(123, 777, nil, nil, nil, nil, nil, nil, nil, true, nil, nil, nil, nil, nil, nil, now, now, nil, nil, nil)
			mock.ExpectQuery(query).WithArgs("hello", amrID).WillReturnRows(amrResult)

			amr, err := backend.UpdateAMR(context.Background(), amrID, updateFields)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(err, ShouldBeNil)
			vAMR, err := amr.AsVinylAMR()
			So(err, ShouldBeNil)
			So(vAMR.AudibleMagicResponseID, ShouldEqual, 123)
		})
	})
}
