package vinyldb

import (
	"code.justin.tv/chat/db"
	"golang.org/x/net/context"
)

// UpdateSelectedThumbnail change a vod's selected thumbnail to the one with the given path
func (b *Backend) UpdateSelectedThumbnail(ctx context.Context, vodID int64, path string) error {
	query := db.BuildQuery(
		"UPDATE vods",
		"SET selected_thumbnail_id = vod_thumbnails.id",
		"FROM vod_thumbnails",
		"WHERE vods.id = ", db.Param, "AND vod_thumbnails.vod_id = ", db.Param, "AND vod_thumbnails.path = ", db.Param,
	)
	_, err := b.conn.Exec(ctx, "update_selected_thumbnail_id", query, vodID, vodID, path)
	return err
}
