package vinyldb

import (
	"strings"

	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	"code.justin.tv/vod/vinyl/errors"
	edgemodels "code.justin.tv/vod/vinyl/models"
	"golang.org/x/net/context"
)

// UpdateVod calls vinylDB to update the fields in the corresponding vod.
func (b *Backend) UpdateVod(ctx context.Context, vodID int64, u *edgemodels.VodUpdateInput) (*models.Vod, error) {
	fields, values, err := models.UpdateVodQuery(*u)
	if err != nil {
		return nil, err
	}
	queryParts := []interface{}{"UPDATE", models.VodTableName, "SET"}
	queryParts = append(queryParts, fields...)
	queryParts = append(queryParts, "WHERE id =", db.Param, "RETURNING ", strings.Join(models.VodFields, ","))
	query := db.BuildQuery(queryParts...)
	values = append(values, vodID)

	rows, err := b.conn.Query(ctx, "update_vod", query, values...)
	res, err := models.ReadVodRows(rows, err, b.logger)
	if err != nil {
		return nil, err
	}
	err = b.AttachVodThumbnails(ctx, res)
	if err != nil {
		return nil, err
	}

	if len(res) != 1 {
		return nil, errors.NotFoundError{Type: "vod", ID: int(vodID)}
	}

	return res[0], nil

}
