package vinyldb

import (
	"strings"
	"time"

	"code.justin.tv/chat/db"
	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"
	edgemodels "code.justin.tv/vod/vinyl/models"
	"golang.org/x/net/context"
)

// UpdateVodNotificationSettings calls vinylDB to update the fields in the corresponding vod settings row.
func (b *Backend) UpdateVodNotificationSettings(ctx context.Context, vodID int64, notificationType string, u *edgemodels.VodNotificationSettingsInput) (*models.VodNotificationSettings, error) {
	fields, updateValues, err := models.UpdateVodNotificationSettingsQuery(*u)
	if err != nil {
		return nil, err
	}

	datastoreNotificationSettings, err := models.FromVinylVodNotificationSettingsInput(u, vodID, notificationType)
	if err != nil {
		return nil, err
	}

	now := time.Now().UTC().Round(time.Second)
	datastoreNotificationSettings.CreatedAt = now
	datastoreNotificationSettings.UpdatedAt = now

	queryParts := []interface{}{
		"INSERT INTO", models.VodNotificationSettingsTableName,
		BuildParamList(models.VodNotificationSettingsCreateFields),
		"VALUES (",
	}
	for i := 0; i < len(models.VodNotificationSettingsCreateFields); i++ {
		if i != 0 {
			queryParts = append(queryParts, ",")
		}
		queryParts = append(queryParts, db.Param)
	}
	queryParts = append(queryParts, ") ON CONFLICT (vod_id, type) DO UPDATE SET")
	queryParts = append(queryParts, fields...)
	queryParts = append(queryParts, "RETURNING ", strings.Join(models.VodNotificationSettingsFields, ","))
	insertQuery := db.BuildQuery(queryParts...)

	insertValues := datastoreNotificationSettings.ValuesList()
	values := make([]interface{}, 0, len(updateValues)+len(insertValues))
	values = append(values, insertValues...)
	values = append(values, updateValues...)

	rows, err := b.conn.Query(ctx, "create_vod_notification_settings", insertQuery, values...)

	createdVodNotificationSettings, err := models.ReadVodNotificationSettingsRows(rows, err, b.logger)
	if err != nil {
		return nil, err
	}

	return createdVodNotificationSettings[0], nil
}
