package vinyldb

import (
	"testing"
	"time"

	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"

	edgemodels "code.justin.tv/vod/vinyl/models"
	"github.com/DATA-DOG/go-sqlmock"
	. "github.com/smartystreets/goconvey/convey"

	"golang.org/x/net/context"
)

func TestUpdateVodNotificationSettings(t *testing.T) {
	Convey("Updating Vods", t, func() {
		mock, backend := Setup()
		enabled := true
		nType := "channel_feed"
		customText := "SC2: what is dead may never die"
		u := &edgemodels.VodNotificationSettingsInput{Enabled: enabled, CustomText: edgemodels.NullString{String: customText, Valid: true}}

		Convey("successfully updates/inserts the settings", func() {
			vodID := int64(420)

			query := `INSERT INTO vod_notification_settings (.+) VALUES (.+) ON CONFLICT (.+) DO UPDATE SET (.+) RETURNING (.+)`
			now := time.Now().UTC().Round(time.Second)
			rows := sqlmock.NewRows(models.VodNotificationSettingsFields).AddRow(1, vodID, nType, now, customText, enabled, nil, now)
			mock.ExpectQuery(query).WithArgs(vodID, nType, now, customText, enabled, nil, now, customText, enabled, now).WillReturnRows(rows)

			_, err := backend.UpdateVodNotificationSettings(context.Background(), vodID, nType, u)
			So(err, ShouldBeNil)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
		})
	})
}
