package vinyldb

import (
	//"database/sql/driver"

	"regexp"
	"testing"
	"time"

	"code.justin.tv/vod/vinyl/datastore/vinyldb/models"

	edgemodels "code.justin.tv/vod/vinyl/models"
	"github.com/DATA-DOG/go-sqlmock"
	. "github.com/smartystreets/goconvey/convey"

	"golang.org/x/net/context"
)

func TestUpdateVods(t *testing.T) {
	Convey("Updating Vods", t, func() {
		mock, backend := Setup()

		Convey("successfully updates a string value", func() {
			vodID := int64(123)
			u := &edgemodels.VodUpdateInput{Status: edgemodels.NullString{String: "recorded", Valid: true}}

			query := `UPDATE vods SET (.+) WHERE (.+) RETURNING (.+)`
			now := time.Now().UTC().Round(time.Second)
			rows := sqlmock.NewRows(models.VodFields).AddRow(1, nil, 34, "archive", nil, nil,
				now, nil, nil, nil, nil, nil, nil,
				1238, nil, nil, nil, nil, nil,
				0, 111, nil, nil, nil, nil, nil,
				now, edgemodels.StatusRecording, nil, nil, now,
				"happy", 0, nil, "", nil)
			mock.ExpectQuery(query).WithArgs(edgemodels.StatusRecorded, AnyTime{}, 123).WillReturnRows(rows)

			fakeVodThumbnails := sqlmock.NewRows([]string{"id", "vod_id", "path", "offset", "type"})
			mock.ExpectQuery(regexp.QuoteMeta(`SELECT id, vod_id, path, "offset", type FROM vod_thumbnails WHERE vod_id IN ( 1 )`)).WillReturnRows(fakeVodThumbnails)

			_, err := backend.UpdateVod(context.Background(), vodID, u)
			So(mock.ExpectationsWereMet(), ShouldBeNil)
			So(err, ShouldBeNil)
		})

		Convey("int value", func() {
			Convey("successfully updates when input is valid", func() {
				vodID := int64(123)
				u := &edgemodels.VodUpdateInput{Duration: edgemodels.NullInt64{Int64: 100, Valid: true}}

				query := `UPDATE vods SET (.+) WHERE (.+) RETURNING (.+)`
				now := time.Now().UTC().Round(time.Second)
				rows := sqlmock.NewRows(models.VodFields).AddRow(1, nil, 34, "archive", nil, nil,
					now, nil, nil, nil, nil, nil, nil,
					1238, nil, nil, nil, nil, nil,
					0, 111, nil, nil, nil, nil, nil,
					now, edgemodels.StatusRecording, nil, nil, now,
					"happy", 0, nil, "", nil)
				mock.ExpectQuery(query).WithArgs(100, AnyTime{}, 123).WillReturnRows(rows)

				fakeVodThumbnails := sqlmock.NewRows([]string{"id", "vod_id", "path", "offset", "type"})
				mock.ExpectQuery(regexp.QuoteMeta(`SELECT id, vod_id, path, "offset", type FROM vod_thumbnails WHERE vod_id IN ( 1 )`)).WillReturnRows(fakeVodThumbnails)

				_, err := backend.UpdateVod(context.Background(), vodID, u)
				So(mock.ExpectationsWereMet(), ShouldBeNil)
				So(err, ShouldBeNil)
			})
		})
	})
}
