package utils

import (
	"log"

	"code.justin.tv/chat/db"
	"code.justin.tv/common/golibs/errorlogger"
)

// CloseRows closes the rows to the db and logs errors if any exist.
func CloseRows(rows db.Rows, logger errorlogger.ErrorLogger) {
	err := rows.Close()
	if err != nil {
		log.Println(err)
		if logger != nil {
			logger.Error(err)
		}
	}
}
