-- +goose Up
-- SQL in section 'Up' is executed when this migration is applied

CREATE EXTENSION IF NOT EXISTS hstore WITH SCHEMA public;

CREATE TABLE audible_magic_responses (
    id integer NOT NULL,
    vod_id integer,
    title text,
    performer text,
    genre text,
    artist text,
    album_title text,
    song text,
    isrc text,
    is_match boolean NOT NULL,
    match_offset_seconds integer,
    match_duration_seconds integer,
    scan_offset_seconds integer,
    scan_duration_seconds integer,
    mute_offset_seconds integer,
    mute_duration_seconds integer,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL,
    song_length_seconds integer,
    unmuted_at timestamp without time zone,
    am_item_id text
);

CREATE SEQUENCE audible_magic_responses_id_seq
    START WITH 1669266627
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;

ALTER SEQUENCE audible_magic_responses_id_seq OWNED BY audible_magic_responses.id;
ALTER TABLE ONLY audible_magic_responses ALTER COLUMN id SET DEFAULT nextval('audible_magic_responses_id_seq'::regclass);
ALTER TABLE ONLY audible_magic_responses
ADD CONSTRAINT audible_magic_responses_pkey PRIMARY KEY (id);
CREATE INDEX index_audible_magic_responses_on_vod_id ON audible_magic_responses USING btree (vod_id);


CREATE TABLE track_appeals (
    id serial PRIMARY KEY,
    audible_magic_response_id integer NOT NULL,
    vod_appeal_id integer NOT NULL,
    reason character varying(255) NOT NULL,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL,
    resolved_at timestamp without time zone
);

CREATE INDEX index_track_appeals_on_audible_magic_response_id ON track_appeals USING btree (audible_magic_response_id);
CREATE INDEX index_track_appeals_on_vod_appeal_id ON track_appeals USING btree (vod_appeal_id);


CREATE TABLE user_video_privacy_properties (
    id serial PRIMARY KEY,
    user_id integer,
    private_video boolean DEFAULT false NOT NULL,
    privacy_options_enabled boolean DEFAULT false NOT NULL,
    hide_archives boolean DEFAULT false NOT NULL,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL
);


CREATE TABLE user_vod_properties (
    id serial PRIMARY KEY,
    user_id integer NOT NULL,
    save_vods_forever boolean,
    vod_storage_days integer,
    force_vod_type character varying(40),
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL,
    autosave_archives boolean,
    killme_trust_archive_uploads boolean,
    killme_archive_upload_allowed boolean,
    can_upload_vod boolean,
    youtube_exporting_disabled boolean
);


CREATE TABLE vod_appeals (
    id serial PRIMARY KEY,
    resolved_at timestamp without time zone,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL,
    vod_id integer NOT NULL,
    full_name character varying(255),
    street_address_1 character varying(255),
    street_address_2 character varying(255),
    city character varying(255),
    state character varying(255),
    zipcode character varying(255),
    country character varying(255),
    priority boolean DEFAULT false
);

CREATE INDEX index_vod_appeals_on_priority ON vod_appeals USING btree (priority);
CREATE INDEX index_vod_appeals_on_vod_id ON vod_appeals USING btree (vod_id);


CREATE TABLE vods (
    id serial PRIMARY KEY,
    owner_id integer,
    broadcast_id bigint,
    broadcast_type character varying(255),
    title text,
    game text,
    started_on timestamp without time zone,
    uri text,
    "offset" integer,
    duration integer,
    status text,
    formats text,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL,
    codecs text,
    bitrates text,
    resolutions text,
    display_names text,
    playlist_preferences text,
    views_count integer,
    tag_hstore hstore,
    thumbnails text,
    description text,
    broadcaster_software text,
    source_archive_id bigint,
    deleted boolean,
    created_by_id integer,
    language character varying(255),
    delete_at timestamp without time zone,
    fps text,
    manifest text,
    viewable_at timestamp without time zone,
    origin text
);

CREATE INDEX index_vods_on_broadcast_id ON vods USING btree (broadcast_id);
CREATE INDEX index_vods_on_broadcast_type ON vods USING btree (broadcast_type);
CREATE INDEX index_vods_on_delete_at ON vods USING btree (delete_at);
CREATE INDEX index_vods_on_game_and_views_count ON vods USING btree (game, views_count DESC);
CREATE INDEX index_vods_on_owner_id_and_created_at ON vods USING btree (owner_id, created_at DESC);
CREATE INDEX index_vods_on_source_archive_id ON vods USING btree (source_archive_id);
CREATE INDEX index_vods_on_started_on ON vods USING btree (started_on);
CREATE INDEX index_vods_on_status ON vods USING btree (status);
CREATE INDEX index_vods_on_uri ON vods USING btree (uri);
CREATE INDEX index_vods_on_views_count ON vods USING btree (views_count);


ALTER TABLE ONLY track_appeals
    ADD CONSTRAINT fk_track_appeals_audible_magic_responses FOREIGN KEY (audible_magic_response_id) REFERENCES audible_magic_responses(id);

ALTER TABLE ONLY track_appeals
    ADD CONSTRAINT fk_track_appeals_vod_appeals FOREIGN KEY (vod_appeal_id) REFERENCES vod_appeals(id);

ALTER TABLE ONLY vod_appeals
    ADD CONSTRAINT fk_vod_appeals_vods FOREIGN KEY (vod_id) REFERENCES vods(id);

-- +goose Down
-- SQL section 'Down' is executed when this migration is rolled back
DROP TABLE vods CASCADE;
DROP TABLE audible_magic_responses CASCADE;
DROP TABLE vod_appeals CASCADE;
DROP TABLE track_appeals CASCADE;
DROP TABLE user_vod_properties CASCADE;
DROP TABLE user_video_privacy_properties CASCADE;
