
-- +goose Up
-- SQL in section 'Up' is executed when this migration is applied
COMMIT;
CREATE INDEX CONCURRENTLY index_vods_on_game_and_language_and_views_count ON vods USING btree (game, language, views_count DESC);
CREATE INDEX CONCURRENTLY index_vods_on_language_and_views_count ON vods USING btree (language, views_count DESC);
BEGIN;

-- +goose Down
-- SQL section 'Down' is executed when this migration is rolled back
COMMIT;
DROP INDEX CONCURRENTLY IF EXISTS index_vods_on_game_and_language_and_views_count;
DROP INDEX CONCURRENTLY IF EXISTS index_vods_on_language_and_views_count;
BEGIN;
