
-- +goose Up
-- SQL in section 'Up' is executed when this migration is applied

CREATE TABLE vod_notification_settings (
    id integer NOT NULL,
    vod_id integer NOT NULL,
    type character varying(255) NOT NULL,
    custom_text text DEFAULT NULL,
    enabled boolean NOT NULL DEFAULT false,
    sent_at timestamp without time zone DEFAULT NULL,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL
);

CREATE SEQUENCE vod_notification_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;

ALTER SEQUENCE vod_notification_settings_id_seq OWNED BY vod_notification_settings.id;
ALTER TABLE ONLY vod_notification_settings ALTER COLUMN id SET DEFAULT nextval('vod_notification_settings_id_seq'::regclass);
ALTER TABLE ONLY vod_notification_settings
    ADD CONSTRAINT vod_notification_settings_pkey PRIMARY KEY (id);

CREATE INDEX index_vod_notification_settings_on_vod_id ON vod_notification_settings USING btree (vod_id);
ALTER TABLE ONLY vod_notification_settings
    ADD CONSTRAINT fk_vod_notification_settings_vods FOREIGN KEY (vod_id) REFERENCES vods(id) ON DELETE CASCADE;

ALTER TABLE ONLY vod_notification_settings
    ADD CONSTRAINT vod_notification_settings_vod_id_type_key UNIQUE (vod_id, type);

-- +goose Down
-- SQL section 'Down' is executed when this migration is rolled back

DROP TABLE IF EXISTS vod_notification_settings;
DROP SEQUENCE IF EXISTS vod_notification_settings_id_seq;
