
-- +goose Up
-- SQL in section 'Up' is executed when this migration is applied
CREATE TABLE vod_thumbnails (
  id bigserial PRIMARY KEY NOT NULL,
  vod_id bigint NOT NULL,
  path text NOT NULL,
  "offset" real,
  type text
);

CREATE UNIQUE INDEX thumbnail_vod_id_path ON vod_thumbnails (vod_id, path);

ALTER TABLE vods ADD COLUMN selected_thumbnail_id bigint;

CREATE TABLE thumbnail_migration_errors (
  vod_id bigint PRIMARY KEY NOT NULL,
  error text
);


-- +goose Down
-- SQL section 'Down' is executed when this migration is rolled back
DROP TABLE IF EXISTS thumbnail_migration_errors CASCADE;
ALTER TABLE vods DROP COLUMN selected_thumbnail_id;
DROP TABLE IF EXISTS vod_thumbnails CASCADE;
