
-- +goose Up
-- SQL in section 'Up' is executed when this migration is applied
ALTER TABLE vods
ADD COLUMN published_at timestamp without time zone;
COMMIT;
CREATE INDEX CONCURRENTLY index_vods_on_owner_id_and_published_at ON vods USING btree (owner_id, published_at DESC);
BEGIN;

-- +goose Down
-- SQL section 'Down' is executed when this migration is rolled back
ALTER TABLE vods
DROP COLUMN published_at;
COMMIT;
DROP INDEX CONCURRENTLY IF EXISTS index_vods_on_owner_id_and_published_at;
BEGIN;

