
-- +goose Up
-- SQL in section 'Up' is executed when this migration is applied
COMMIT;
CREATE INDEX CONCURRENTLY index_vods_on_game_and_language_and_published_at ON vods USING btree (game, language, published_at DESC);
CREATE INDEX CONCURRENTLY index_vods_on_game_and_published_at ON vods USING btree (game, published_at DESC);
CREATE INDEX CONCURRENTLY index_vods_on_language_and_published_at ON vods USING btree (language, published_at DESC);
CREATE INDEX CONCURRENTLY index_vods_on_published_at ON vods USING btree (published_at DESC);
BEGIN;

-- +goose Down
-- SQL section 'Down' is executed when this migration is rolled back
COMMIT;
DROP INDEX CONCURRENTLY IF EXISTS index_vods_on_game_and_language_and_published_at;
DROP INDEX CONCURRENTLY IF EXISTS index_vods_on_game_and_published_at;
DROP INDEX CONCURRENTLY IF EXISTS index_vods_on_language_and_published_at;
DROP INDEX CONCURRENTLY IF EXISTS index_vods_on_published_at;
BEGIN;
